/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorType;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeHolder;
import eu.europa.ec.taxud.cesop.readers.CesopParsingException;
import eu.europa.ec.taxud.cesop.readers.UnknownXsdVersionException;
import eu.europa.ec.taxud.cesop.readers.XmlLocation;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import eu.europa.ec.taxud.cesop.validation.CesopValidationException;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationException;

public final class ExceptionHandler {
    private ExceptionHandler() {
    }

    public static ValidationError handleException(Exception e, String messageRefId) {
        ValidationError validationError;
        if (e instanceof CesopValidationException) {
            validationError = ((CesopValidationException)e).getValidationError();
        } else if (e instanceof XMLValidationException) {
            validationError = ExceptionHandler.handleXmlValidationException((XMLValidationException)e, messageRefId);
        } else if (e.getCause() instanceof XMLValidationException) {
            validationError = ExceptionHandler.handleXmlValidationException((XMLValidationException)e.getCause(), messageRefId);
        } else if (e instanceof UnknownXsdVersionException || e instanceof CesopParsingException || e instanceof XMLStreamException) {
            validationError = ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0010, messageRefId);
            validationError.setErrorLongDesc(e.getMessage());
        } else {
            validationError = ExceptionHandler.handleUnexpectedException(e, messageRefId);
        }
        return validationError;
    }

    private static ValidationError handleXmlValidationException(XMLValidationException e, String messageRefId) {
        Location location = e.getValidationProblem().getLocation();
        ValidationErrorTypeEnum errorCode = ExceptionHandler.deriveErrorCodeFromLocation(location);
        ValidationErrorType validationError = ValidationErrorTypeHolder.INSTANCE.findByCode(errorCode.getCode());
        String longDescription = validationError.getLongDescription() + "\nError in line: " + location.getLineNumber() + ", column: " + location.getColumnNumber() + ": " + e.getValidationProblem().getMessage();
        ValidationError result = ValidationErrorUtils.createValidationError(errorCode, messageRefId);
        result.setErrorLongDesc(longDescription);
        return result;
    }

    private static ValidationErrorTypeEnum deriveErrorCodeFromLocation(Location location) {
        List<String> path;
        if (location instanceof XmlLocation && !(path = ((XmlLocation)location).getXmlPath()).isEmpty()) {
            String topElem;
            switch (topElem = path.get(path.size() - 1)) {
                case "DocRefId": {
                    return ValidationErrorTypeEnum.CM_BR_0030;
                }
                case "CorrDocRefId": {
                    return ValidationErrorTypeEnum.CM_BR_0040;
                }
                case "MessageRefId": {
                    return ValidationErrorTypeEnum.MH_BR_0050;
                }
                case "CorrMessageRefId": {
                    return ValidationErrorTypeEnum.MH_BR_0060;
                }
            }
        }
        return ValidationErrorTypeEnum.CM_TR_0010;
    }

    private static ValidationError handleUnexpectedException(Exception e, String messageRefId) {
        return ValidationErrorUtils.createCustomError(messageRefId, "An unexpected error has occurred: " + e.getMessage());
    }
}

